-- events for gamecomplete screen

timer = 0;
phase = 0;
prevphase = 0;
events = {0.8,1.6,2.2,2.8,3.0,3.2,4.2,5.0,10.0};

fireworks = 8;
fireworkarray = {}
rocketspeed = 0;

function OnLoad ()
	CacheSound ("music/bonus.ogg");
	NX_GetBitmap("fxs/purplestar.png");
	CacheSound ("sfx/whistle.ogg");
	CacheSound ("sfx/crash.ogg");
	CacheSound ("sfx/zap.ogg");
end;

function OnEnter ()
    Azkend_SetMenuBackground("story/endimage.jpg");
 	SetProperty ("/GameComplete:enter_trans_duration", 4);
    SetProperty ("/GameComplete:leave_trans_duration", 1);
	SwitchMusic ("music/bonus.ogg", 2, 3);	
	--PlaySound ("music/episodestart.ogg")
	PlaySound ("sfx/zap.ogg");
	reset();
	
	
end;

function reset()
	fireworkarray = {};
	for i = 1, fireworks, 1 do
  		temp = spawnFireWork(1);
		table.insert(fireworkarray , i, temp);
  	end;
  	
	timer = 0;
	phase = 0;
	prevphase = 0;
	SetProperty("info:label.text", "Phase: "..phase);
	rocketspeed = 0;
	SetProperty("title1:visible", 0);
	SetProperty("logo:alpha", 0.0);
	SetProperty("title2:visible", 0);
end;

function spawnFireWork(silent)
	temppi = {}	
	temppi.y = 610 + (math.random(0,600))
	temppi.x = math.random(0,800);	
	temppi.explodes = math.random(0,300);
	Print ("Created fw at "..temppi.x..","..temppi.y.."\n");
	
	whistle = math.random();
	if(whistle < 0.25 and silent == 0) then
		PlaySound("sfx/whistle.ogg")
	end;
	
	return temppi;
end;

function OnLeave ()

end;

function getCurrentPhase(time)
	cphase = 0;
	for i,v in ipairs(events) do 
		if(time < v) then
			return cphase;
		end;
		cphase = cphase + 1;
	end;
	return cphase;
end;

function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	getCurrentPhase(timer);	
	if (name == "reset") then	
		reset();
	end;
	
	if (name == "Ok") then
		DeleteGameState ();
		SwitchScreen ("MainMenu");
		PushScreen ("Stats");
		PushScreen ("Credits");
		return;
	end;
	
end;

function spawnIt(name)
	spawnAppearFx(name);
	SetProperty(name..":visible", 1);
	SetProperty(name..":alpha", 1.0);
	PlaySound ("sfx/thunder.ogg")
end;

function OnUpdate (tdelta)

    timer = timer + tdelta;    
	akey = GetActiveScreenAnimKey ();		
	trans = GetActiveScreenTransPhase ();
	alpha = trans;
	
	t = 1.1 * timer;
    
    SetProperty ("bg:alpha", GetActiveScreenTransPhase()*4)
    SetProperty ("pergament:alpha", GetActiveScreenTransPhase())
    
    phase = getCurrentPhase(timer);
    if(phase ~= prevphase) then
    	SetProperty("info:label.text", "Phase: "..phase);
    	if(phase == 1) then
    		spawnIt("title1") 	
    	end;
    	if(phase == 2) then
    		spawnIt("logo") 	
    	end;
    	if(phase == 3) then
    		spawnIt("title2") 	
    	end;   	
    	if(phase == 4) then
    		rocketspeed = 280;
    		PlaySound ("sfx/crash.ogg");
    	end;
    	
    	prevphase = phase;
    end;
    
    
    -- Do Magic Balls!!!
    
    for i = 1, fireworks, 1 do
		if(testIfExplodes(fireworkarray [i]["y"], fireworkarray [i]["explodes"]) == 0) then
			fireworkarray [i]["y"] = fireworkarray[i]["y"] - (rocketspeed * tdelta);		
			
			if(math.fmod(math.floor(fireworkarray [i]["y"]),12) == 0 and fireworkarray [i]["y"] < 600) then
				SpawnFX ("fxs/trail.lua", fireworkarray[i]["x"], fireworkarray[i]["y"], 0, 0);	
			end;
		else			
			SpawnFX ("fxs/fireworks.lua", fireworkarray[i]["x"], fireworkarray[i]["y"], 180, 0);	
			fireworkarray[i] =  spawnFireWork(0);	
		end;		
	end;
    
end;

function testIfExplodes(ycord, explodes)

	if(ycord < explodes) then
		return 1;
	end;
	
	--probability = (600 - ycord) / 600 / 64;
	--result = math.random();
	--if(probability > result) then
		--return 1;
	--end;
	return 0;
end;

function clamp01 (value)
	value = math.min (value, 1);
	value = math.max (value, 0);
	return value;
end;

function spawnAppearFx(name)

	x = GetProperty(name..":aligned_position.x");
	y = GetProperty(name..":aligned_position.y");
	width = GetProperty(name..":width");
	height = GetProperty(name..":height");
	step = 40
	
	for k = y, y+height, step do
		for i = x, x+width, step do
			--Print("pos: ".. i.."\n")
			SpawnFX ("fxs/shockwave.lua", i, k, 180, 0);	
		end;	
	end;
end;

function OnDraw ()
	NX_SetBlend ("ADDITIVE")
	for i = 1, fireworks, 1 do
		--sinewave = 15 * math.sin((fireworkarray[i]["y"] / 80));
		rotationsine = 125 * math.sin((fireworkarray[i]["y"] / 30));
		--scale = math.sin((fireworkarray[i]["y"] / 30))/2 + 1.5
		
		scale = fireworkarray[i]["y"] / 600 + 0.5
		--Print("Drawing at " .. fireworkarray[i]["y"] .. " " .. fireworkarray[i]["x"].. "\n");
		NX_DrawBitmapRS ("fxs/purplestar.png", fireworkarray[i]["x"], fireworkarray[i]["y"], rotationsine/180*3.1415926535, scale);
	end;
	NX_SetBlend ("NORMAL")
end;
